#include <stdio.h>
#include <stdlib.h>

typedef struct {
    long long x;
    long long y;
    int index;
} Vector;

int half(const Vector *v) {
    if (v->y > 0) return 0;
    if (v->y == 0 && v->x > 0) return 0;
    return 1;
}

long long cross(const Vector *a, const Vector *b) {
    return a->x * b->y - a->y * b->x;
}

int cmp(const void *a, const void *b) {
    const Vector *A = (const Vector *)a;
    const Vector *B = (const Vector *)b;
    int ha = half(A);
    int hb = half(B);
    if (ha != hb) return ha - hb;
    long long c = cross(A, B);
    if (c > 0) return -1;
    if (c < 0) return 1;
    return 0;
}

long long sq(long long x) {
    return x * x;
}

int main() {
    int n;
    if (scanf("%d", &n) != 1) return 0;

    Vector *v = malloc(n * sizeof(Vector));
    for (int i = 0; i < n; i++) {
        scanf("%lld %lld", &v[i].x, &v[i].y);
        v[i].index = i + 1;
    }

    qsort(v, n, sizeof(Vector), cmp);

    Vector *d = malloc(2 * n * sizeof(Vector));
    for (int i = 0; i < n; i++) {
        d[i] = v[i];
        d[i + n] = v[i];
    }

    long long best = 0;
    long long sx = 0, sy = 0;
    int l = 0, best_l = -1, best_r = -1;

    for (int r = 0; r < 2 * n; r++) {
        sx += d[r].x;
        sy += d[r].y;

        while (l <= r && (r - l + 1 > n || cross(&d[l], &d[r]) < 0)) {
            sx -= d[l].x;
            sy -= d[l].y;
            l++;
        }

        long long val = sq(sx) + sq(sy);
        if (val > best) {
            best = val;
            best_l = l;
            best_r = r;
        }
    }

    if (best == 0) {
        printf("0\n\n");
    } else {
        int k = best_r - best_l + 1;
        printf("%d\n", k);
        for (int i = best_l; i <= best_r; i++) {
            printf("%d%s", d[i].index, i == best_r ? "" : " ");
        }
        printf("\n");
    }

    free(v);
    free(d);
    return 0;
}